<?php 

extract(shortcode_atts(array(
  "heading_tag" => "h3", 
  'text' => '',
  "btn_style" => "see-through", 
  'margin_top' => '',
  'margin_right' => '',
  'margin_bottom' => '', 
  'margin_left' => '', 
  'padding_top' => '',
  'padding_right' => '',
  'padding_bottom' => '', 
  'padding_left' => '', 
  'button_color' => '',
  'btn_type' => '', 
  "link_text" => "", 
  'text_color' => '', 
  'next_section_color' => '',
  'display' => 'block',
  'url' => '', 
  'link_type' => 'regular', 
  'alignment' => 'left', 
  'class' => '' ), $atts));

$target                 = ($link_type == 'new_tab') ? 'target="_blank"' : null;
$style                  = (!empty($text_color)) ? ' style="color: '.$text_color.';"' : null;
$bg_style               = (!empty($text_color)) ? ' style="background-color: '.$text_color.';"' : null;
$underline_border_color = $text_color;
$text_color             = (!empty($text_color)) ? 'custom' : 'std';

// Margins.
$margins = '';

if( !empty($margin_top) ) {
  $margins .= 'margin-top: '.intval($margin_top).'px; ';
}
if( !empty($margin_right) ) {
  $margins .= 'margin-right: '.intval($margin_right).'px; ';
}
if( !empty($margin_bottom) ) {
  $margins .= 'margin-bottom: '.intval($margin_bottom).'px; ';
}
if( !empty($margin_left) ) {
  $margins .= 'margin-left: '.intval($margin_left).'px;';
}

// Padding.
$padding = '';

if( !empty($padding_top) ) {
  $padding .= 'padding-top: '.intval($padding_top).'px; ';
}
if( !empty($padding_right) ) {
  $padding .= 'padding-right: '.intval($padding_right).'px; ';
}
if( !empty($padding_bottom) ) {
  $padding .= 'padding-bottom: '.intval($padding_bottom).'px; ';
}
if( !empty($padding_left) ) {
  $padding .= 'padding-left: '.intval($padding_left).'px;';
}

$using_bg_color = ( !empty($button_color) && 'default' !== $button_color ) ? 'true' : 'false';

$style_markup = null;
$style_padding_markup = null;

if( !empty($margins) ) {
  $style_markup = 'style="'.$margins.'"';
} 
if( !empty($padding) ) {
  $style_padding_markup = 'style="'.$padding.'"';
} 

// Material style.
if( $btn_style === 'material' ) {
  
  echo '<div class="nectar-cta '. esc_attr( $class ).'" data-style="'.esc_attr($btn_style).'" data-alignment="'.esc_attr($alignment).'" data-display="'. esc_attr($display) .'" data-text-color="'.esc_attr($text_color).'" '.$style_markup.'>';
  echo '<'.esc_html($heading_tag).'> <span class="text">'.wp_kses_post($text).' </span>';
  echo  '<span class="link_wrap" '.$style.'><a '.$target .' class="link_text" href="'.esc_url($url).'">'.wp_kses_post($link_text).'<span class="circle" '.$bg_style.'></span><span class="arrow"></span></a></span>'; 
  echo '</'.esc_html($heading_tag).'></div>';
} 
// See through.
else if( $btn_style === 'see-through' ) {
  echo '<div class="nectar-cta '.$class.'" data-color="'. esc_attr($button_color) .'" data-using-bg="'.esc_attr($using_bg_color).'" data-style="'.esc_attr($btn_style).'" data-display="'. esc_attr($display) .'" data-alignment="'.esc_attr($alignment).'" data-text-color="'.esc_attr($text_color).'" '.$style_markup.'>';
  echo '<'.esc_html($heading_tag). $style.'> <span class="text">'.wp_kses_post($text).' </span>';
  echo  '<span class="link_wrap" '.$style_padding_markup.'><a '.$target .' class="link_text" href="'.esc_url($url).'">'.wp_kses_post($link_text).'<span class="arrow"></span></a></span>'; 
  echo '</'.esc_html($heading_tag).'></div>';
} 
// Arrow Animation.
else if( $btn_style === 'arrow-animation' ) {
  echo '<div class="nectar-cta '.$class.'" data-color="'. esc_attr($button_color) .'" data-using-bg="'.esc_attr($using_bg_color).'" data-style="'.esc_attr($btn_style).'" data-display="'. esc_attr($display) .'" data-alignment="'.esc_attr($alignment).'" data-text-color="'.esc_attr($text_color).'" '.$style_markup.'>';
  echo '<'.esc_html($heading_tag). $style.'>';
  echo  '<span class="link_wrap" '.$style_padding_markup.'><a '.$target .' class="link_text" href="'.esc_url($url).'"><span class="text">'.wp_kses_post($link_text) .'</span>'; 
  echo '<svg class="next-arrow" width="20px" height="25px" viewBox="0 0 50 80" xml:space="preserve">
  <polyline stroke="#ffffff" stroke-width="9" fill="none" stroke-linecap="round" stroke-linejoin="round" points="0, 0 45, 40 0, 80"/>
  </svg>  ';
  echo '<span class="line" '.$bg_style.'></span> </a></span>';
  echo '</'.esc_html($heading_tag).'></div>';
} 
// Next section link.
else if( $btn_style === 'next-section' ) {
  
  $using_next_section_color = 'false';
  $next_section_color_style = null;
  $next_section_track_ball_color_style = null;
  
  if( !empty($next_section_color) ) {
    $using_next_section_color = 'true';
  }
  
  if( $btn_type === 'down-arrow-bounce' ) {
    
    if( !empty($next_section_color) ) {
      $next_section_color_style = 'style="background-color: '.esc_attr($next_section_color).';"';
    }
    echo '<div class="nectar-next-section-wrap bounce" '.$style_markup.' data-custom-color="'.esc_attr($using_next_section_color).'"><a href="#" '.$next_section_color_style.' class="nectar-next-section skip-hash"> <i class="fa fa-angle-down"></i> </a></div>';
  } 
  else if( $btn_type === 'down-arrow-bordered' ) {
    
    if( !empty($next_section_color) ) {
      $next_section_color_style = 'style="border-color: '.esc_attr($next_section_color).'; color: '.esc_attr($next_section_color).';"';
    }
    echo '<div class="nectar-next-section-wrap down-arrow-bordered" '.$style_markup.' data-custom-color="'.esc_attr($using_next_section_color).'"><div class="inner" '.$next_section_color_style.'><a href="#" class="nectar-next-section skip-hash"><i class="fa fa-angle-down top"></i><i class="fa fa-angle-down"></i></a></div></div>';
  } 
  else if( $btn_type === 'mouse-wheel' ) {
    if( !empty($next_section_color) ) {
      $stroke_color = $next_section_color;
      $next_section_color_style = 'style="border-color: '.esc_attr($next_section_color).'; color: '.esc_attr($next_section_color).';"';
      $next_section_track_ball_color_style = 'style="background-color: '.esc_attr($next_section_color).';"';
    } else {
      $stroke_color = '#ffffff';
    }
    echo '<div class="nectar-next-section-wrap mouse-wheel" '.$style_markup.' data-custom-color="'.esc_attr($using_next_section_color).'"><a href="#" '.$next_section_color_style.' class="nectar-next-section skip-hash"><svg class="nectar-scroll-icon" viewBox="0 0 30 45" enable-background="new 0 0 30 45">
          <path class="nectar-scroll-icon-path" fill="none" stroke="'.esc_attr($stroke_color).'" stroke-width="2" stroke-miterlimit="10" d="M15,1.118c12.352,0,13.967,12.88,13.967,12.88v18.76  c0,0-1.514,11.204-13.967,11.204S0.931,32.966,0.931,32.966V14.05C0.931,14.05,2.648,1.118,15,1.118z"></path>
        </svg><span class="track-ball" '.$next_section_track_ball_color_style.'></span></a></div>';
  }
  
  else if ( $btn_type === 'minimal-arrow' ) {
    
    if( !empty($next_section_color) ) {
      $stroke_color = $next_section_color;
    } else {
      $stroke_color = '#ffffff';
    }
    
    echo '<div class="nectar-next-section-wrap minimal-arrow" '.$style_markup.' data-custom-color="'.esc_attr($using_next_section_color).'">
    <a href="#" class="nectar-next-section skip-hash">
      <svg class="next-arrow" width="40px" height="68px" viewBox="0 0 40 50" xml:space="preserve">
      <path stroke="'.esc_attr($stroke_color).'" stroke-width="2" fill="none" d="M 20 0 L 20 51"></path>
      <polyline stroke="'.esc_attr($stroke_color).'" stroke-width="2" fill="none" points="12, 44 20, 52 28, 44"></polyline>
      </svg>
    </a>
  </div>';
  }
  
} 

// All others.
else {
  echo '<div class="nectar-cta '.esc_attr($class).'" data-color="'. esc_attr($button_color) .'" data-using-bg="'.esc_attr($using_bg_color).'" data-display="'. esc_attr($display) .'" data-style="'.esc_attr($btn_style).'" data-alignment="'.esc_attr($alignment).'" data-text-color="'.esc_attr($text_color).'" '.$style_markup.'>';
  echo '<'.esc_html($heading_tag). $style.'> <span class="text">'.wp_kses_post($text).' </span>';
  $border_color_attr = (!empty($underline_border_color)) ? 'style="border-color: '.esc_attr($underline_border_color).';"' : '';
  echo  '<span class="link_wrap" '.$style_padding_markup.'><a '.$target .' class="link_text" '.$border_color_attr.' href="'.esc_url($url).'">'.wp_kses_post($link_text).'</a></span>'; 
  echo '</'.esc_html($heading_tag).'></div>';
}


?>